/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.entities.boat;

import com.renyigesai.immortalers_delight.Config;
import com.renyigesai.immortalers_delight.entities.boat.AncientWoodBoat;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightBlocks;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightEntities;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightTags;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class ImmortalersBoat
extends Boat {
    protected float deltaRotation;
    public static final EntityDataAccessor<Integer> DATA_ID_MOD_TYPE = SynchedEntityData.m_135353_(ImmortalersBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ImmortalersBoat(EntityType<? extends Boat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ImmortalersBoat(Level level, double pX, double pY, double pZ) {
        this((EntityType<? extends Boat>)((EntityType)ImmortalersDelightEntities.IMMORTAL_BOAT.get()), level);
        this.m_6034_(pX, pY, pZ);
        this.f_19854_ = pX;
        this.f_19855_ = pY;
        this.f_19856_ = pZ;
    }

    public Item m_38369_() {
        return switch (this.getBoatVariant()) {
            default -> throw new IncompatibleClassChangeError();
            case Type.HIMEKAIDO -> (Item)ImmortalersDelightItems.HIMEKAIDO_BOAT.get();
            case Type.ANCIENT_WOOD -> (Item)ImmortalersDelightItems.ANCIENT_WOOD_BOAT.get();
            case Type.LEISAMBOO -> Items.f_42743_;
            case Type.PEARLIP_SHELL -> (Item)ImmortalersDelightItems.PEARLIP_SHELL_BOAT.get();
        };
    }

    public void m_213560_(DamageSource damageSource) {
        if (this.getBoatVariant() == Type.ANCIENT_WOOD) {
            Level level = this.m_9236_();
            BlockPos pos = this.m_20183_();
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)Items.f_42398_, 2), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (double)0.0, (double)0.0, (double)0.0);
            this.m_19983_(new ItemStack((ItemLike)ImmortalersDelightItems.ANCIENT_WOOD_PLANKS.get(), 3));
        } else {
            super.m_213560_(damageSource);
        }
    }

    public void setVariant(Type pVariant) {
        this.f_19804_.m_135381_(DATA_ID_MOD_TYPE, (Object)pVariant.ordinal());
    }

    public Type getBoatVariant() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_MOD_TYPE));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_MOD_TYPE, (Object)Type.HIMEKAIDO.ordinal());
    }

    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128359_("ModType", this.getBoatVariant().m_7912_());
    }

    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("ModType", 8)) {
            this.setVariant(Type.byName(pCompound.m_128461_("ModType")));
        }
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        if (this.getBoatVariant() == Type.ANCIENT_WOOD) {
            ItemStack otherHand;
            ItemStack hand = pPlayer.m_21120_(pHand);
            if (this.buildLargeBoat(hand, otherHand = pPlayer.m_21120_(pHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND), pPlayer)) {
                return InteractionResult.SUCCESS;
            }
            if (this.buildLargeBoat(otherHand, hand, pPlayer)) {
                return InteractionResult.SUCCESS;
            }
            return super.m_6096_(pPlayer, pHand);
        }
        return super.m_6096_(pPlayer, pHand);
    }

    private boolean buildLargeBoat(ItemStack hand, ItemStack otherHand, Player pPlayer) {
        if (hand.m_204117_(ImmortalersDelightTags.ANCIENT_BOAT_NEED_1) && hand.m_41613_() >= Config.ancientBoatNeeded_1 && otherHand.m_204117_(ImmortalersDelightTags.ANCIENT_BOAT_NEED_2) && otherHand.m_41613_() >= Config.ancientBoatNeeded_2) {
            AncientWoodBoat largeBoat = new AncientWoodBoat(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (!pPlayer.m_150110_().f_35937_) {
                hand.m_41774_(Config.ancientBoatNeeded_1);
                otherHand.m_41774_(Config.ancientBoatNeeded_2);
            }
            largeBoat.setVariant(this.getBoatVariant());
            this.m_9236_().m_7967_((Entity)largeBoat);
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12630_, SoundSource.BLOCKS, 0.8f, 0.8f, false);
            this.m_146870_();
            return true;
        }
        return false;
    }

    public InteractionResult imm$Interact(Player pPlayer, InteractionHand pHand) {
        return super.m_6096_(pPlayer, pHand);
    }

    public static enum Type implements StringRepresentable
    {
        HIMEKAIDO((Block)ImmortalersDelightBlocks.HIMEKAIDO_PLANKS.get(), "himekaido"),
        LEISAMBOO((Block)ImmortalersDelightBlocks.LEISAMBOO_PLANKS.get(), "leisamboo"),
        PEARLIP_SHELL((Block)ImmortalersDelightBlocks.PEARLIP_SHELL_PLANKS.get(), "pearlip_shell"),
        ANCIENT_WOOD((Block)ImmortalersDelightBlocks.ANCIENT_WOOD_PLANKS.get(), "ancient_wood");

        private final String name;
        private final Block planks;
        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;

        private Type(Block pPlanks, String pName) {
            this.name = pName;
            this.planks = pPlanks;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int pId) {
            return BY_ID.apply(pId);
        }

        public static Type byName(String pName) {
            return (Type)CODEC.m_262792_(pName, (Enum)HIMEKAIDO);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
            BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

